%------------------------------------------------------------------------------
% File     : SEU476^1 : TPTP v7.4.0. Released v3.6.0.
% Domain   : Set Theory (Binary relations)
% Problem  : Swaping transitive closure and reflexive closure
% Version  : [Nei08] axioms.
% English  : Taking the transitive closure of the reflexive closure is the same
%            as taking the reflexive closure of the transitive closure.

% Refs     : [BN99]  Baader & Nipkow (1999), Term Rewriting and All That
%          : [Nei08] Neis (2008), Email to Geoff Sutcliffe
% Source   : [Nei08]
% Names    :

% Status   : Theorem
% Rating   : 0.86 v7.4.0, 0.89 v7.2.0, 0.88 v7.0.0, 1.00 v3.7.0
% Syntax   : Number of formulae    :   59 (   0 unit;  29 type;  29 defn)
%            Number of atoms       :  256 (  34 equality; 160 variable)
%            Maximal formula depth :   12 (   7 average)
%            Number of connectives :  162 (   4   ~;   4   |;  12   &; 126   @)
%                                         (   0 <=>;  16  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  199 ( 199   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   31 (  29   :;   0   =)
%            Number of variables   :   87 (   0 sgn;  39   !;   5   ?;  43   ^)
%                                         (  87   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : Some proofs can be found in chapter 2 of [BN99]
%          : 
%------------------------------------------------------------------------------
%----Include axioms of binary relations
include('Axioms/SET009^0.ax').
%------------------------------------------------------------------------------
thf(composing_transitive_closure_and_reflexive_closure,conjecture,(
    ! [R: $i > $i > $o] :
      ( ( tc @ ( rc @ R ) )
      = ( rc @ ( tc @ R ) ) ) )).

%------------------------------------------------------------------------------
